 <?php
##############################################################################
#
#   Copyright 2005 - 2007 - Doug Kapell as www.sillydns.com
#   Version 1.4 published by Jean Schumacher www.rotserver.lu
#  
#   This file is part of The Statusmon Service Monitoring program (Statusmon).
#
#   Statusmon is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   Statusmon is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Statusmon; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
##############################################################################
# 
#   Status Monitor - Free uptime and service monitoring script from www.rootserver.lu
#   
#
##############################################################################

include('db987.php');
include('service.class.php');
include('server.class.php');
include('setting.class.php');

// For full error reporting
error_reporting(E_ALL);
$result = mysql_query("SELECT name,value FROM settings") or die ("Couldn't connect to server.");
while(list($name,$value) = mysql_fetch_row($result))
    $settings["$name"] = $value;


$downhost = "google.com";
$downflag = true;
$service = new Service($connection);
$servicelist = $service->listServices();
$server = new Server($connection);
$serverlist = $server->listServers($server_sort);
printf("# servers monitored: %d<br>", count($serverlist));

if (count($serverlist) > 0) {
    foreach($serverlist as $key=>$value)
    {
        echo "<b>$value</b><br>";
        $downCount = 0;
        $message = "";
        $complete = "\nMonitored Services:\n\n";
        $serverinfo = $server->getInfo($key);
        foreach($servicelist as $skey=>$svalue)
        {
            if($server->monitorServer($key,$skey))
            {
                $status = $service->getStatus($key,$skey);
                $notified = $service->getNotify($key,$skey);
                $serviceinfo = $service->getInfo($skey);
                $fp = @fsockopen($serverinfo["ip"], $serviceinfo["port"], $errno, $errstr, 4);
                if (!$fp)
                {
                    if ($downflag)
                    {
                        $downfp = @fsockopen($downhost, 80, $errno, $errstr, 30);
                        if (!$downfp) die("Could not connect to $downhost.  Stats update terminating.");
                        else
                        {
                            $downflag = false;
                            fclose($downfp);
                        }
                    }
                    $downCount++;
                    echo $svalue.": <font color=\"red\">Down</font><br>";
                    $server->setStatus($key,$skey,0);
                    $server->addHistory($key,$skey,0,$nowdate);
                    $complete .= "    $svalue: DOWN\n";
                    if ($notified == 1)
                    {
                        $hist = $service->getHistory($key,$skey,$settings["downtime_trigger"]);

                        $total = 0;
                        foreach($hist as $hkey=>$hval)
                        {
                           if ($hval == 1) $total++;
                        }
                        if ($total == 0)
                        {
                            $service->setNotify($key,$skey,0);
                            $message .= "    $svalue: service has changed from up to DOWN\n";
                        }
                    }
                }
                else
                {
                    $server->setStatus($key,$skey,1);
                    $server->addHistory($key,$skey,1,$nowdate);
                    echo $svalue.": <font color=\"green\">Up</font><br>";
                    $complete .= "    $svalue: UP\n";
                    if ($notified == 0)
                    {
                        $service->setNotify($key,$skey,1);
                        $message .= "    $svalue: service has changed from down to UP\n";
                    }
                    fclose($fp);
                }
            }
            else
            {
                $server->setStatus($key,$skey,-1);
                $server->addHistory($key,$skey,-1,$nowdate);
            }
        }
        if ($message != '' && $settings["use_email"] == 'YES')
        {
            $subject = "Service Change on $value: ";
            $subject .= $downCount ? "$downCount DOWN" : "ALL UP";
            $titlemessage = "A service change has occured on server $value:\n\n";
            mail($settings["to_email"],$subject,$titlemessage.$message.$complete,"from:".$settings["from_email"]);
        }
        $server->setUpdateTime($key,$nowdate);
    }
}
else
{
    echo "No servers being monitored currently.";
}

?>