<?php
##############################################################################
#
#   Copyright 2005 - 2007 - Doug Kapell as www.sillydns.com
#   Version 1.4 published by Jean Schumacher www.rotserver.lu
#  
#   This file is part of The Statusmon Service Monitoring program (Statusmon).
#
#   Statusmon is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   Statusmon is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Statusmon; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
##############################################################################
# 
#   Status Monitor - Free uptime and service monitoring script from www.rootserver.lu
#   
#
##############################################################################
session_start();

include('db987.php');
include('server.class.php');
include('service.class.php');
include('setting.class.php');

// For full error reporting
error_reporting(E_ALL);

unset($warning, $noserverid, $feedback, $num_history);
print("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">
<html>
<head>
	<title>". $title ."</title>
<link rel=\"shortcut icon\" href=\"favicon.ico\" type=\"image/x-icon\">
<link rel=\"icon\" href=\"favicon.ico\" type=\"image/x-icon\">
<LINK rel=\"stylesheet\" type=\"text/css\" href=\"style.css\">
	<style type=\"text/css\">
body {}
td.rtitleorder {background-color: ".  $reportercolorbk ."; text-align: left; font-weight: bold; color: ".  $reportercolorft ."; font-family: tahoma veranda;  font-family: Tahoma, Verdana, Arial, 'Andale Mono', sans-serif;font-size: 11px;}
td.rtitleorder2 {background-color: ".  $reportercolorbk ."; text-align: left; font-weight: bold; color: ".  $reportercolorft ."; font-family: tahoma veranda; font-family: Tahoma, Verdana, Arial, 'Andale Mono', sans-serif;font-size: 11px;}
td.rdetailorder {background-color: white; text-align: center; font-family: tahoma veranda; font-family: Tahoma, Verdana, Arial, 'Andale Mono', sans-serif;font-size: 11px;}
td.rdetailorder2 {background-color: white; text-align: left; font-family: tahoma veranda; font-family: Tahoma, Verdana, Arial, 'Andale Mono', sans-serif;font-size: 11px;}
</style>
</head>

<body>
<BR>
 <table width=\"300\" border=\"0\" align=\"center\" cellpadding=\"4\" cellspacing=\"0\" align=\"center\">");

if (!isset($_GET['serverid']))
{
    print("<tr><td colspan=\"2\" align=\"center\" class=font style=\"color: red;\">No Server Selected</td></tr>
    <tr><td style=\"text-align: center;\"> <img src=\"images\statusmon.gif\" alt=\"Free uptime and service monitoring script from www.rootserver.lu\" border=\"0\"></td></tr>
    <tr><td class=\"rdetailorder2\" style=\"text-align: center; font-size: 9px;\">Free uptime and service monitoring script from <a target=\"_blank\" href=\"http://www.rootserver.lu\">rootserver.lu</a></td></tr>
    <tr><td class=\"rdetailorder2\" style=\"text-align: center; font-size: 9px;\">
    <form method=\"post\"><p align=\"center\"><input type=\"button\" value=\"Close Window\" onclick=\"window.close()\"></p></form></td></tr>
    </table></body></html>");
    exit;
}
else {
$serverid = $_GET['serverid'];
}

$current_date = date("Y-m-d");
$server = new Server($connection);
$serviceid = $server->getMonitoringService($serverid);

$arrUptime = $server->getUptimeStats($serverid,$serviceid,0,null,null);

// unarchived data
$ua_downtime = $arrUptime['downtime'];
$ua_sdate = $arrUptime['sdate'];
$ua_uptime = $arrUptime['uptime'];

// Prepare a few dates
$date1 = strtotime($ua_sdate);
$date2 = strtotime($current_date);

$serverinfo = $server->getInfo($serverid);

// # months of unarchived data
$nummonths = number_format(count_days($date1, $date2),0);
$maxarch = abs($nummonths - $maxdisplay);

//GET Archived data for display
$maxarchivesql = mysql_query("SELECT * FROM `archive` WHERE `serverid`='". $serverid ."' ORDER BY `date` DESC LIMIT ". $maxarch ."")
or die  (mysql_error());

$arrArchUptime = $server->getArchStats($serverid,NULL);
$percentoutages = $arrArchUptime['uptime'];
$numoutages =  $arrArchUptime['outages'];

// number months of archived data
$numarchivedata  = $server->getNumArchMonth($serverid);

// total outages for server
$totaloutages = $arrUptime['downtime'] + $numoutages;

// 1st month of archived data
$FirstMonthArch  = $server->getfirstArchMonth($serverid);
if(is_null($FirstMonthArch)) {
$FirstMonthArch = $arrUptime['sdate'];
}

//COMBINE uptime percentages for archived and non archived data.
$totalperc = $server->getCombUptimeStats($numarchivedata,$percentoutages,$nummonths,$arrUptime['uptime']);

?>
<tr>
	<td>
   <table align="center" border="0" style="width:400;" CELLPADDING="0" CELLSPACING="0" class="" bordercolor="black">
   <tr><td>
  <table align="center" border="0" style="width:375;" CELLPADDING="2" CELLSPACING="2" class="" bordercolor="black">
	<tr>
		<td colspan=4 class=rtitleorder style="text-align: center;"><b>Server <span style="font-size: 16px;"><?php echo $serverinfo['name']; ?></span><BR>Up-Time History Summary:</b></td>
	</tr>
	<tr>
		<td colspan=2 class=rtitleorder><b>Status Monitoring:</b></td>
		<td class=rtitleorder>Outages</td>
		<td class=rtitleorder>Uptime</td>
	</tr>
	<tr>
		<td class="rdetailorder2">Since:</td>
		<td class="rdetailorder2"><?php echo strftime("%b-%d-%Y",strtotime($FirstMonthArch)); ?></td>
		<td class="rdetailorder2"><?php echo $totaloutages; ?></td>
		<td class="rdetailorder2" style="font-weight: bold;"><?php printf ("%01.4f", $totalperc); ?>%</td>
	</tr>
		  </table>
<BR>
<table align="center" border="0" style="width:375;" CELLPADDING="2" CELLSPACING="2" class="" bordercolor="black">
	<tr>
		<td colspan=4 class=rtitleorder><b>Up-Time History Detail:</b></td>
	</tr>
	<tr>
		<td class=rtitleorder>Year</td>
		<td class=rtitleorder>Month</td>
		<td class=rtitleorder>Outages</td>
		<td class=rtitleorder>Uptime</td>
	</tr>
	<?php

	$start_monitor_date = strftime("%G-%m-%d",strtotime($arrUptime['sdate']));

	$current_date = date("Y-m-d");
$num_months_report = jang_diff($start_monitor_date, $current_date, "d");

if ($num_months_report >= "3") {
$num_months_report = "3";
}

		$i = 0;
	while ($i <= $num_months_report) {

	 //Get the current month
	$datearray = getdate(mktime(0,0,0,date("m")-$i, date("d"),  date("Y")));
	$month = $datearray['mon'];
	$year = $datearray['year'];

	/*Use the function to get an array containing the two timestamps*/
	$getmonth_array = get_month_stamp($month, $year);

	$arrUptime = $server->getUptimeStats($serverid,$serviceid,1,date("Y-m-d", $getmonth_array['start']),date("Y-m-d", $getmonth_array['end']));


	$i++;
	 ?>
	<tr>
		<td class="rdetailorder2"><?php echo $datearray['year']; ?></td>
		<td class="rdetailorder2"><?php echo $datearray['month']; ?></td>
		<td class="rdetailorder2"><?php echo $arrUptime['downtime']; ?></td>
		<td class="rdetailorder2" style="font-weight: bold;"><?php printf ("%01.4f", $arrUptime['uptime']); ?>%</td>
	</tr>
	<?php }
	
	//BEGIN Arhived data
	if ($thissql = mysql_fetch_array($maxarchivesql)) {
	    do {	
	

	$thismonth = date("M", strtotime($thissql['date']));
	$thisyear = date("Y", strtotime($thissql['date']));
	
	?>
	<tr>
		<td class="rdetailorder2"><?php echo $thisyear ?></td>
		<td class="rdetailorder2"><?php echo $thismonth; ?></td>
		<td class="rdetailorder2"><?php echo $thissql['outages']; ?></td>
		<td class="rdetailorder2" style="font-weight: bold;"><?php printf ("%01.4f", $thissql['uptime']); ?>%</td>
	</tr>
	<?php 
	
	} while ($thissql = mysql_fetch_array($maxarchivesql));
	
	}; //END Arhived data
	

	?>
		  </table>
		  </td>
		</tr>
		</table>
		<tr>
			<td style="text-align: center;"> <img src="images/statusmon.gif" alt="Free uptime and service monitoring script from www.rootserver.lu" border="0">
			</td>
		</tr>
		<tr>
			<td class="rdetailorder2" style="text-align: center; font-size: 9px;"><?php echo $tag; ?>
			</td>
		</tr>
		<tr>
			<td class="rdetailorder2" style="text-align: center; font-size: 9px;">
					<form method="post">
					<p align="center">
					<input type="button" value="Close Window"
					onclick="window.close()"> </p>
					</form>
			</td>
		</tr>

		</table>
</body>
</html>

<?php
	// Get date difference between two given dates
// $returntype: s = seconds, m = minutes, h = hours, d = days
// int date_diff(int start_date, int end_date[, string return_type])
function jang_diff($start_date, $end_date, $returntype="d")
{
   if ($returntype == "s")
       $calc = 1;
   if ($returntype == "m")
       $calc = 60;
   if ($returntype == "h")
       $calc = (60*60);
   if ($returntype == "d")
       $calc = (60*60*24*30);

   $_d1 = explode("-", $start_date);
   $y1 = $_d1[0];
   $m1 = $_d1[1];
   $d1 = $_d1[2];

   $_d2 = explode("-", $end_date);
   $y2 = $_d2[0];
   $m2 = $_d2[1];
   $d2 = $_d2[2];

   if (($y1 < 1970 || $y1 > 2037) || ($y2 < 1970 || $y2 > 2037))
   {
       return 0;
   } else
   {
       $today_stamp    = mktime(0,0,0,$m1,$d1,$y1);
       $end_date_stamp    = mktime(0,0,0,$m2,$d2,$y2);
       $difference    = round(($end_date_stamp-$today_stamp)/$calc);
       return $difference;
   }
}
?>

