<?php
##############################################################################
#
#   Copyright 2005 - 2007 - Doug Kapell as www.sillydns.com
#   Version 1.4 published by Jean Schumacher www.rotserver.lu
#  
#   This file is part of The Statusmon Service Monitoring program (Statusmon).
#
#   Statusmon is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   Statusmon is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Statusmon; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
##############################################################################
# 
#   Status Monitor - Free uptime and service monitoring script from www.rootserver.lu
#   
#
##############################################################################

// BEGIN EDITS

$dbhost = '';
$dbuser = '';
$dbpass = '';
$db = '';

// Enter cron update frequency in minutes
$cron_freq = '10';

// END EDITS
  
/* Database Connection Stuff */
$connection = mysql_connect($dbhost,$dbuser,$dbpass);
if (!$connection) {
$connected = 'N';
}
else {
$connected = 'Y';
mysql_select_db($db, $connection) or die("Couldn't select database.");
}



/*BEGIN FUNCTION*/
/*Returns an array with two timestamps, one for the start day of the month and
one for the end day. I expanded the month_end array's creation a little bit to make it easier to understand. I'm sure this has been done elsewhere but I couldn't find it when I looked.*/
if (!function_exists("get_month_stamp")){
function get_month_stamp($month, $year){
    //Set month information
    $month_end = array(
                              1 => 31,
                             2 => 28,
                             3 => 31,
                             4 => 30,
                             5 => 31,
                             6 => 30,
                             7 => 31,
                             8 => 31,
                             9 => 30,
                             10 => 31,
                             11 => 30,
                             12 => 31
                             );
    //Select end day of month to work with
    $end_day = $month_end[$month];

    //Make time stamps
    $start_stamp = mktime(0, 0, 0, $month, 1, $year);
    $end_stamp = mktime(23, 59, 59, $month, $end_day, $year);

    //Make array for return
    $month_array = array('start'=>$start_stamp, 'end'=>$end_stamp);
    Return $month_array;

}
}

// Will return the number of days between the two dates passed in
function count_days($a, $b) {
    // First we need to break these dates into their constituent parts:
    $a_parts = getdate($a);
    $b_parts = getdate($b);

    // Now recreate these timestamps, based upon noon on each day
    // The specific time doesn't matter but it must be the same each day
    $a_new = mktime(12, 0, 0, $a_parts['mon'], $a_parts['mday'], $a_parts['year']);
    $b_new = mktime(12, 0, 0, $b_parts['mon'], $b_parts['mday'], $b_parts['year']);

    // Subtract these two numbers and divide by the number of seconds in a
    //  day.  Round the result since crossing over a daylight savings time
    //  barrier will cause this time to be off by an hour or two.
    $days = round(abs($a_new - $b_new) / 86400);
    $months = $days / 30;
    if ($months < 1) {$months = "1";}
    return $months;
}


/*END FUNCTION*/
?>
