<?php
##############################################################################
#
#   Copyright 2005 - 2007 - Doug Kapell as www.sillydns.com
#   Version 1.4 published by Jean Schumacher www.rotserver.lu
#  
#   This file is part of The Statusmon Service Monitoring program (Statusmon).
#
#   Statusmon is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   Statusmon is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Statusmon; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
##############################################################################
# 
#   Status Monitor - Free uptime and service monitoring script from www.rootserver.lu
#   
#
##############################################################################

session_start();

include('db987.php');
include('server.class.php');
include('service.class.php');
include('setting.class.php');

// testing T or F
//$test = 'F';
$test = 'T';

// For full error reporting
//error_reporting(E_ALL);

  // Initialize server
  $server = new Server($connection);
  $serverlist = $server->listServers($server_sort);
  

          //Get the current month
	$currmonth = date('F');
	$curryear = date('Y');
	$currserver = $key;
	$currdate = "01" . $currmonth . " " . $curryear;
	// $currdate = strtotime($currdate);
	
	  $admin_message = "\n***** Arhived records  - $currdate *****\n";
	  if ($test == 'T') {
  	  $admin_message .= "\nTEST TEST TEST TEST TEST\n\n";
	  }
	  
  foreach($serverlist as $key=>$value){ 
 
 $info = $server->getInfo($key);
  
  
  $serviceid = $server->getMonitoringService($key);
  $arrUptime = $server->getUptimeStats($key,$serviceid,0,null,null);
  $serverinfo = $server->getInfo($key);
  $servername = $serverinfo['name'];
  
  if (!is_null($arrUptime['sdate'])) {

	$start_monitor_date = strftime("%G-%m-%d",strtotime($arrUptime['sdate']));
	

	$current_date = date("Y-m-d");
	$num_months_report = jang_diff($start_monitor_date, $current_date, "d");

	$i = 0;
	while ($i <= $num_months_report) {

	 //Get the current month
	$datearray = getdate(mktime(0,0,0,date("m")-$i, date("d"),  date("Y")));
	$month = $datearray['mon'];
	$year = $datearray['year'];
	
		//echo "month: " . $month . " year " . $year;

	/*Use the function to get an array containing the two timestamps*/
	$getmonth_array = get_month_stamp($month, $year);

	$arrUptime = $server->getUptimeStats($key,$serviceid,1,date("Y-m-d", $getmonth_array['start']),date("Y-m-d", $getmonth_array['end']));

	$i++;
	 
	 if ($currmonth == $datearray['month'] && $curryear == $datearray['year']) { // current month, do nothing.
	  $admin_message .= "Current months data found for ". $servername .", no action taken\n";
	  $admin_message .= "\n====================\n\n";
	 }
	 else {
	 	 $thisdate = date('Y/m/d', $getmonth_array['start']);
	 	 $Archive = $server->ArchiveStats($key,$arrUptime['uptime'],$arrUptime['downtime'],$thisdate,$test,$servername);
	 	 $res = substr($Archive, 0, 5);
	 	 if ($res == 'Error') { // Error do not purge recordsa
		  $admin_message .= $Archive . "\n";
	 	  $admin_message .= "====================\n\n";
	 	 }
	 	 else { // no error, lets purge old records
	 	 $admin_message .= $Archive . "\n";
	 	 $Delete = $server->DeleteStats($key,date("Y-m-d", $getmonth_array['start']),date("Y-m-d", $getmonth_array['end']),$test);
	 	 
		 $admin_message .= $Delete . " rows deleted for " . $datearray['month'] . "/" .$datearray['year'] . "\n";
		 $admin_message .= "====================\n\n";

	 	 }
	       } 
            } 
	 }
	}
  $admin_subject = "statusmon arhived records on $currdate *****";
  
 
  $server->sendArchEmail($archive_email,$admin_subject,$admin_message,$archive_from_email);
  
    if ($test == 'F') {
   $server->Archlog($admin_message,'cron');  
  }
		
	// Get date difference between two given dates
// $returntype: s = seconds, m = minutes, h = hours, d = days
// int jang_diff(int start_date, int end_date[, string return_type])
function jang_diff($start_date, $end_date, $returntype="d")
{
   if ($returntype == "s")
       $calc = 1;
   if ($returntype == "m")
       $calc = 60;
   if ($returntype == "h")
       $calc = (60*60);
   if ($returntype == "d")
       $calc = (60*60*24*30);

   $_d1 = explode("-", $start_date);
   $y1 = $_d1[0];
   $m1 = $_d1[1];
   $d1 = $_d1[2];

   $_d2 = explode("-", $end_date);
   $y2 = $_d2[0];
   $m2 = $_d2[1];
   $d2 = $_d2[2];

   if (($y1 < 1970 || $y1 > 2037) || ($y2 < 1970 || $y2 > 2037))
   {
       return 0;
   } else
   {
       $today_stamp    = mktime(0,0,0,$m1,$d1,$y1);
       $end_date_stamp    = mktime(0,0,0,$m2,$d2,$y2);
       $difference    = round(($end_date_stamp-$today_stamp)/$calc);
       return $difference;
   }
}
?>
