<?php
##############################################################################
#
#   Copyright 2005 - 2007 - Doug Kapell as www.sillydns.com
#   Version 1.4 published by Jean Schumacher www.rotserver.lu
#  
#   This file is part of The Statusmon Service Monitoring program (Statusmon).
#
#   Statusmon is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   Statusmon is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Statusmon; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
##############################################################################
# 
#   Status Monitor - Free uptime and service monitoring script from www.rootserver.lu
#   
#
##############################################################################

session_start();

include('db987.php');
include('server.class.php');
include('service.class.php');
include('setting.class.php');

if (isset($_POST['test'])) {
$test = $_POST['test'];
}
else {
$test = 'T';
}


// For full error reporting
error_reporting(E_ALL);

//if(!session_is_registered('auth'))
if(!isset($_SESSION['auth']))
{
    header ("Location: admin.php");
	exit();
}

print("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">
<html>
<head>
	<title>" . $title ."</title>
	<link rel=\"shortcut icon\" href=\"favicon.ico\" type=\"image/x-icon\">
<link rel=\"icon\" href=\"favicon.ico\" type=\"image/x-icon\">
<LINK rel=\"stylesheet\" type=\"text/css\" href=\"style.css\">
</head>

<body>
<BR>
 <table width=\"400\" border=\"0\" align=\"center\" cellpadding=\"4\" cellspacing=\"0\" align=\"center\">");

if (!isset($_POST['serverid']))
{
  // Initialize server
  $server = new Server($connection);
  $serverlist = $server->listServers($server_sort);
  
    print("<tr><td colspan=\"2\" align=\"center\" class=\"titleorder\" style=\"font-size: 16px;\">Data archive & purge - Select a server</td></tr>");
    foreach($serverlist as $key=>$value){ 
    	$info = $server->getInfo($key);
    	print("<tr><td colspan=\"2\" align=\"center\" class=font style=\"color: back;\"><form method=\"post\" name=\"form\" action=\"". $_SERVER['PHP_SELF'] . "\" id=\"form\">
    	<input type=\"hidden\" name=\"serverid\" value=\"" . $key . "\"> <strong>Server: " . $value. "</strong>
    	<BR>TEST <select name=\"test\">
                <option value=\"F\">No
                <option value=\"T\" selected>Yes
                </select>
    	<input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"GO\" style=\";\"></td>
		     </tr></form></td></tr>");
    }
    print("<tr><td class=\"detailorder2\" style=\"text-align: center; font-size: 11px;\">
    <strong>Run once per month for each server, ideally on the 1st of the month<BR>or just run the cron archive script. ;)</strong><BR><BR>
    <a href=\"admin.php\">Back to admin.php</td></tr>
    <tr><td class=\"detailorder2\" style=\"text-align: center; font-size: 9px;\">". $tag ."</td></tr>
    
    </table></body></html>");
    exit;
}

$server = new Server($connection);
$serviceid = $server->getMonitoringService($_POST['serverid']);
$arrUptime = $server->getUptimeStats($_POST['serverid'],$serviceid,0,null,null);
$serverinfo = $server->getInfo($_POST['serverid']);
$servername = $serverinfo['name'];

//Get the current month
$currmonth = date('F');
$curryear = date('Y');
$currserver = $_POST['serverid'];
$currdate = "01" . $currmonth . " " . $curryear;
	
$admin_message = "\n***** Arhived records  - $currdate *****\n";
?>
<tr>
	<td>
   <table align="center" border="0" style="width:400;" CELLPADDING="0" CELLSPACING="0" class="" bordercolor="black">
   <tr><td>
  <table align="center" border="0" style="width:375;" CELLPADDING="2" CELLSPACING="2" class="" bordercolor="black">
	<?php if ($test == 'T') { ?>
	<tr>
		<td class="detailorder2" colspan=4 style="text-align: center; font-weight: bold; color: red; font-size: 14px;">***** Test mode is active *****</td>
	</tr>
	<?php } ?>
	<tr>
		<td colspan=4 class=titleorder style="text-align: center;"><b>Server <span style="font-size: 16px;"><?php echo $serverinfo['name']; ?></span></b></td>
	</tr>
	
		  </table>
<table align="center" border="0" style="width:375;" CELLPADDING="2" CELLSPACING="2" class="" bordercolor="black">
	<tr>
		<td colspan=4 class=titleorder><b>Data archive & purge</b></td>
	</tr>
	<?php
	if (!is_null($arrUptime['sdate'])) {

	$start_monitor_date = strftime("%G-%m-%d",strtotime($arrUptime['sdate']));
	

	$current_date = date("Y-m-d");
	$num_months_report = jang_diff($start_monitor_date, $current_date, "d");

	


		$i = 0;
	while ($i <= $num_months_report) { ?>
	<tr>
		<td class="detailorder2">
	<?

	 //Get the current month
	$datearray = getdate(mktime(0,0,0,date("m")-$i, date("d"),  date("Y")));
	$month = $datearray['mon'];
	$year = $datearray['year'];
	
		//echo "month: " . $month . " year " . $year;

	/*Use the function to get an array containing the two timestamps*/
	$getmonth_array = get_month_stamp($month, $year);

	$arrUptime = $server->getUptimeStats($_POST['serverid'],$serviceid,1,date("Y-m-d", $getmonth_array['start']),date("Y-m-d", $getmonth_array['end']));


	$i++;
	 
	 if ($currmonth == $datearray['month'] && $curryear == $datearray['year']) { // current month, do nothing.
	 $thismonth = 'true';
	 echo "<strong>Current months data found for ". $servername .", no action taken</strong>";
	 echo "<BR>====================<BR><BR>";
	 $admin_message .= "Current months data found for ". $servername .", no action taken\n";
	 $admin_message .= "\n====================\n\n";
	 }
	 else {
	 	 $thismonth = '';
	 	 $thisdate = date('Y/m/d', $getmonth_array['start']);
	 	 $Archive = $server->ArchiveStats($currserver,$arrUptime['uptime'],$arrUptime['downtime'],$thisdate,$test,$servername);
	 	 $res = substr($Archive, 0, 5);
	 	 if ($res == 'Error') {
	 	 echo $Archive;
	 	 echo "<BR>====================<BR><BR>";
	 	 $admin_message .= $Archive . "\n";
	 	 $admin_message .= "====================\n\n";
	 	 }
	 	 else {
	 	 echo $Archive;
	 	 $Delete = $server->DeleteStats($currserver,date("Y-m-d", $getmonth_array['start']),date("Y-m-d", $getmonth_array['end']),$test);
		 echo  "<BR>" .$Delete . " rows deleted for " . $datearray['month'] . "/" .$datearray['year'];
		 echo "<BR>====================<BR><BR>";
		 $admin_message .= $Archive . "\n";
		 $admin_message .= $Delete . " rows deleted for " . $datearray['month'] . "/" .$datearray['year'] . "\n";
		 $admin_message .= "====================\n\n";
	 	 }
		
		
	 ?>
		</td>
	</tr>
	<?php } } 
	
		if ($test == 'F') {
			$server->Archlog($admin_message,'Web'); 
		}
	}
	else {
	echo "<tr>
		<td class=\"detailorder2\">No data found, no action taken<BR>====================<BR><BR></td></tr>";
	}
	

	?>
		  </table>
		  </td>
		</tr>
		</table>
		<tr>
			<td style="text-align: center;"> <img src="images/statusmon.gif" alt="" border="0">
			</td>
		</tr>
		<tr>
			<td class="detailorder2" style="text-align: center; font-size: 9px;"><?php echo $tag; ?>
			</td>
		</tr>
		<tr>
			<td class="detailorder2" style="text-align: center; font-size: 9px;">
		    	
					<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?> ">
					<p align="center"><input class="formfield" name="action" type="Submit" value="Back to server list" style=";"> </p>
					</form>
			</td>
		</tr>

		</table>
</body>
</html>

<?php
	// Get date difference between two given dates
// $returntype: s = seconds, m = minutes, h = hours, d = days
// int jang_diff(int start_date, int end_date[, string return_type])
function jang_diff($start_date, $end_date, $returntype="d")
{
   if ($returntype == "s")
       $calc = 1;
   if ($returntype == "m")
       $calc = 60;
   if ($returntype == "h")
       $calc = (60*60);
   if ($returntype == "d")
       $calc = (60*60*24*30);

   $_d1 = explode("-", $start_date);
   $y1 = $_d1[0];
   $m1 = $_d1[1];
   $d1 = $_d1[2];

   $_d2 = explode("-", $end_date);
   $y2 = $_d2[0];
   $m2 = $_d2[1];
   $d2 = $_d2[2];

   if (($y1 < 1970 || $y1 > 2037) || ($y2 < 1970 || $y2 > 2037))
   {
       return 0;
   } else
   {
       $today_stamp    = mktime(0,0,0,$m1,$d1,$y1);
       $end_date_stamp    = mktime(0,0,0,$m2,$d2,$y2);
       $difference    = round(($end_date_stamp-$today_stamp)/$calc);
       return $difference;
   }
}
?>
