<?php

/*
##############################################################################
#
#   Copyright 2005 - 2007 - Doug Kapell as www.sillydns.com
#   Version 1.4 published by Jean Schumacher www.rotserver.lu
#  
#   This file is part of The Statusmon Service Monitoring program (Statusmon).
#
#   Statusmon is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   Statusmon is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Statusmon; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
##############################################################################
# 
#   Status Monitor - Free uptime and service monitoring script from www.rootserver.lu
#   For help or suggestions visit http://www.sillydns.com
#
##############################################################################
#
*/

session_start();

include('db987.php');
include('server.class.php');
include('service.class.php');
include('setting.class.php');
showHeader();


unset($warning, $settingswarning, $serviceswarning, $notloggedin, $feedback);


if (isset($_POST['iflogmein']))
{
    // Conver to simple variables
    $username = $_POST['username'];
    $password = $_POST['password'];

    if((!$username) || (!$password)){
        $feedback = 'Please enter ALL required information!';
	    $notloggedin = "true";
    } elseif (validatelogin($username,$password,$connection))
    {
  //      session_register('auth');
         $_SESSION["auth"] = 'Yes';
  //       $auth = 'Yes';
		unset($notloggedin, $feedback);
    }
    else $feedback = "Login Incorrect";
}

if (isset($_POST['forgotpass']))
{
    //logic here
    if(forgotpass($_POST['email'],$connection)) $feedback = "Password has been sent to ".$_POST['email'].".";
    else $feedback = "That email address is not on file.";
}

//if(!session_is_registered('auth'))
if (!isset($_SESSION['auth']))

{
    if ($feedback == "") $feedback =  ' You must login to access this page. ';
	$notloggedin = "true";
}
else
{
    switch($_REQUEST['type'])
    {
        case 'server':
            $server = new Server($connection);
            switch($_POST['action'])
            {
                case 'Add':
                    $warning = $server->addServer($_POST['servername'],$_POST['serverip']);
                    break;
                case 'Delete':
                    $warning = $server->deleteServer($_POST['id']);
                    break;
                case 'Update':
                    $warning = $server->updateServer($_POST['id'],$_POST['servername'],$_POST['serverip'],$_POST['alertra']);
                    break;
            }
            break;
        case 'settings':
            switch($_POST['action'])
            {
                case 'Update':
                    $value = $_POST['value'];
	                mysql_query("UPDATE settings SET value = '$value' WHERE id = '" . $_POST['id'] . "'");
                    $settingswarning = 'Record has been updated ';
                    break;
            }
            break;
        case 'services':
            $service = new Service($connection);
            switch($_POST['action'])
            {
                case 'Add':
                    $serviceswarning = $service->addService($_POST['name'],$_POST['port'],$_POST['default'],$_POST['aletra']);
                    break;
                case 'Update':
                    $serviceswarning = $service->updateService($_POST['id'],$_POST['name'],$_POST['port'],$_POST['default']);
                    break;
                case 'Delete':
                    $serviceswarning = $service->deleteService($_POST['id']);
                    break;
            }
            break;
        case 'logout':
            logout();
            exit;
            break;
        case 'changepass':
            if (isset($_POST['action'])) changepass($connection);
            else changepassform();
            exit;
            break;
        case 'servermonitor':
            $server = new Server($connection);
            if(isset($_POST['action']))
            {
                if (isset($_POST["monitor"])) $warning = $server->setMonitoringService($_POST["serverid"],$_POST["monitor"]);
                else $warning = $server->updateMonitor($_POST);
            }
            else
            {
                servermonitor($_REQUEST['id'],$connection);
                exit;
            }
            break;
    }

    // Getting settings from db

    $settings = mysql_query("SELECT * FROM settings where `show` = 'Y' ORDER BY `id` ASC") or die ("Couldn't connect to settings.");

    // Get servers from status
    $servers = mysql_query("SELECT * FROM servers") or die ("Couldn't connect to server.");

    // Get services
    $services = mysql_query("SELECT * FROM services") or die ("Couldn't connect to server.");
    

}

 if (isset($notloggedin))
 {
    showLoginForm($feedback);
 }
 else
 {
     $service = new Service($connection);
     
     $dir = ".";
     $installexists = scandir4($dir);
     
     if ($installexists == 'YES') {
     
	    echo "<table align=\"center\" border=\"0\" style=\"width:750;\" CELLPADDING=\"0\" CELLSPACING=\"0\" class=\"\" bordercolor=\"black\"><tr><td><BR><center><span style=\"font-weight: bold; color: red; font-size: 16px;\"> ====== Please delete the install.php file before continuing. ====== </span><BR></td></tr></table>";
     }
          echo "<BR><center><a href=\"admin.php?type=changepass\">Change Password</a> | <a href=\"admin.php?type=logout\">Logout</a></center><BR>";
     echo "<table align=\"center\" border=\"0\" style=\"width:750;\" CELLPADDING=\"0\" CELLSPACING=\"0\" class=\"\" bordercolor=\"black\"><tr><td>\n";
     echo "<table border=\"1\" style=\"width:750;\" CELLPADDING=\"2\" CELLSPACING=\"2\" class=\"\" bordercolor=\"black\">\n";
     echo "<tr><td colspan=6><b>Manage your servers:</b></td></tr>\n";
     if (isset($warning))
     {
	    echo "<tr><td colspan=6 style=\"color: red; font-weight: bold;\">" .$warning . "</td></tr>\n";
     }
     echo "<tr><td class=titleorder>Server ID</td><td class=titleorder>Server Name</td><td class=titleorder>Server IP</td><td class=titleorder>Alertra Abrv</td><td colspan=\"2\" class=titleorder>&nbsp;</td></tr>\n";
     if ($serversarray = mysql_fetch_array($servers))
     {
		 do
		 {
		     printf("<tr><form method=\"post\" name=\"form\" action=\"admin.php\" id=\"form\">
             <input type=\"hidden\" name=\"id\" value=\"%s\">
             <input type=\"hidden\" name=\"type\" value=\"server\">
		     <td class=detailorder><a href=\"admin.php?type=servermonitor&id=%s\">%s</a></td>
		     <td class=detailorder>
		     <input type=\"text\" name=\"servername\" value=\"%s\"></td>
		     <td class=detailorder>
		     <input type=\"text\" name=\"serverip\" value=\"%s\"></td>
		     <td class=detailorder><input type=\"text\" name=\"alertra\" value=\"%s\" size=\"10\"></td>
		     <td><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Update\" style=\";\"></td>
		     <td><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Delete\" style=\";\"></td>
		     </tr></form>\n", $serversarray["id"], $serversarray["id"], $serversarray["id"], $serversarray["name"], $serversarray["ip"], $serversarray["alertra"]);
		 }
         while ($serversarray = mysql_fetch_array($servers));
     }
     else
     {
         echo "<tr><td colspan=5><b>No servers being monitored currently</b></td></tr>\n";
	 }
	 printf("<tr><form method=\"post\" name=\"form\" action=\"admin.php\" id=\"form\">
	 <td class=detailorder>&nbsp;</td>
     <td class=detailorder>
     <input type=\"text\" name=\"servername\" value=\"\"></td>
     <input type=\"hidden\" name=\"type\" value=\"server\">
     <td class=detailorder>
     <input type=\"text\" name=\"serverip\" value=\"\"></td>
     <td class=detailorder><input type=\"text\" name=\"alertra\" value=\"\" size=\"10\"></td>
     <td colspan=\"2\" style=\"text-align: center;\"><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Add\" style=\"\"></td>
     </tr></form></TABLE>\n");
     echo "<P>&nbsp;</P>";

	  //Display service monitors

      echo "<table border=\"1\" style=\"width:750;\" CELLPADDING=\"2\" CELLSPACING=\"2\" class=\"\" bordercolor=\"black\">\n";
	  echo "<tr><td colspan=5><b>Services to monitors:</b></td></tr>\n";
	  if (isset($serviceswarning))
      {
	      echo "<tr><td colspan=5 style=\"color: red; font-weight: bold;\">" .$serviceswarning . "</td></tr>\n";
	  }
	  echo "<tr><td class=titleorder>Service</td><td class=titleorder>Port</td><td class=titleorder>Monitor this service by default</td><td colspan=\"2\" class=titleorder>&nbsp;</td></tr>\n";
	  if ($servicelist = mysql_fetch_array($services))
      {
		 do
		 {
		     if ($servicelist['default'])
		     {
		         $yes = "checked=\"true\"";
		         $no = "";
		     }
		     else
		     {
		         $yes = "";
		         $no = "checked=\"true\"";
		     }
		     printf("<tr><form method=\"post\" name=\"form\" action=\"admin.php\" id=\"form\">
             <input type=\"hidden\" name=\"id\" value=\"%s\">
             <input type=\"hidden\" name=\"type\" value=\"services\">
		     <td class=detailorder><input type=\"text\" name=\"name\" value=\"%s\"></td>
		     <td class=detailorder>
		     <input type=\"text\" name=\"port\" value=\"%s\" size=\"10\"></td>
		     <td class=detailorder><input type=\"radio\" name=\"default\" value=\"1\" %s>&nbsp;YES&nbsp;&nbsp;&nbsp;
					    	  <input type=\"radio\" name=\"default\" value=\"0\" %s>&nbsp;NO</td>
		     <td><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Update\" style=\";\"></td>
		     <td><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Delete\" style=\";\"></td>
		     </tr></form>\n", $servicelist["id"], $servicelist["name"], $servicelist["port"], $yes, $no);
		 }
         while ($servicelist = mysql_fetch_array($services));
     }
     else
     {
         echo "<tr><td colspan=5><b>No services being monitored currently</b></td></tr>\n";
	 }
	 printf("<tr><form method=\"post\" name=\"form\" action=\"admin.php\" id=\"form\">
	 <td class=detailorder><input type=\"text\" name=\"name\" value=\"\"></td></td>
     <input type=\"hidden\" name=\"type\" value=\"services\">
     <td class=detailorder>
     <input type=\"text\" name=\"port\" value=\"\" size=\"10\"></td>
     <td class=detailorder><input type=\"radio\" name=\"default\" value=\"1\" checked=\"true\">&nbsp;YES&nbsp;&nbsp;&nbsp;
	 <input type=\"radio\" name=\"default\" value=\"0\">&nbsp;NO</td>
     <td colspan=\"2\" style=\"text-align: center;\"><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Add\" style=\"\"></td>
     </tr></form></TABLE>\n");
     echo "<P>&nbsp;</P>";
     //Display system settings

	  echo "<table border=\"1\" style=\"width:750;\" CELLPADDING=\"2\" CELLSPACING=\"2\" class=\"\" bordercolor=\"black\">\n";
	  echo "<tr><td colspan=5><b>System Settings:</b></td></tr>\n";
	  if ($settingsarray = mysql_fetch_array($settings))
	  {
	      if (isset($settingswarning))
	      {
	          echo "<tr><td colspan=5 style=\"color: red; font-weight: bold;\">" .$settingswarning . "</td></tr>\n";
	      }
	      echo "<tr><td class=titleorder>Name</td><td class=titleorder style=\"width:250px;\">Value</td><td class=titleorder>Description</td><td class=titleorder>&nbsp;</td></tr>\n";
	      do
	      {
	          if ($settingsarray["name"] == "uptime_service")
	          {
	              $servicelist = $service->listServices();
	              printf("<tr><form method=\"post\" name=\"form\" action=\"admin.php\" id=\"form\">
	              <input type=\"hidden\" name=\"id\" value=\"%s\">
	              <input type=\"hidden\" name=\"type\" value=\"settings\">
	              <td class=detailorder>%s</td>
	              <td class=detailorder><select name=\"value\">",$settingsarray["id"], $settingsarray["name"]);
	              foreach($servicelist as $servicekey=>$serviceval)
	              {
	                  if ($settingsarray["value"] == $servicekey) echo "<option value=\"$servicekey\" selected>$serviceval";
	                  else echo "<option value=\"$servicekey\">$serviceval";
	              }
	              printf("</select></td>
	              <td class=detailorder>%s</td>
	              <td><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Update\" style=\";\"></td>
	              </tr></form>\n", $settingsarray["desc"]);
	          }
	          elseif ($settingsarray["name"] == "server_sort")
	          {
	              printf("<tr><form method=\"post\" name=\"form\" action=\"admin.php\" id=\"form\">
	              <input type=\"hidden\" name=\"id\" value=\"%s\">
	              <input type=\"hidden\" name=\"type\" value=\"settings\">
	              <td class=detailorder>%s</td>
	              <td class=detailorder><select name=\"value\">",$settingsarray["id"], $settingsarray["name"]);
	              
	                   
	              echo "<option value=\"1\""; if ($settingsarray["value"] == '1') { echo "selected"; } echo ">Server name ascending";
	              echo "<option value=\"2\""; if ($settingsarray["value"] == '2') { echo "selected"; } echo " >Server name descending";
				  echo "<option value=\"3\""; if ($settingsarray["value"] == '3') { echo "selected"; } echo " >Server id ascending";
				  echo "<option value=\"4\""; if ($settingsarray["value"] == '4') { echo "selected"; } echo " >Server id descending";
				  
	              printf("</select></td>
	              <td class=detailorder>%s</td>
	              <td><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Update\" style=\";\"></td>
	              </tr></form>\n", $settingsarray["desc"]);
	          }
	          elseif ($settingsarray["name"] == "LastUpdateFmt")
	          {
	              printf("<tr><form method=\"post\" name=\"form\" action=\"admin.php\" id=\"form\">
	              <input type=\"hidden\" name=\"id\" value=\"%s\">
	              <input type=\"hidden\" name=\"type\" value=\"settings\">
	              <td class=detailorder>%s</td>
	              <td class=detailorder><select name=\"value\">",$settingsarray["id"], $settingsarray["name"]);
	              
	                   
	              echo "<option value=\"Actual\""; if ($settingsarray["value"] == 'Actual') { echo " selected"; } echo ">Actual Time";
	              echo "<option value=\"Delta\""; if ($settingsarray["value"] == 'Delta') { echo " selected"; } echo " >Time since update";
				  
	              printf("</select></td>
	              <td class=detailorder>%s</td>
	              <td><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Update\" style=\";\"></td>
	              </tr></form>\n", $settingsarray["desc"]);
	          }
	          else
	          {
	              printf("<tr><form method=\"post\" name=\"form\" action=\"admin.php\" id=\"form\">
	              <input type=\"hidden\" name=\"id\" value=\"%s\">
	              <input type=\"hidden\" name=\"type\" value=\"settings\">
	              <td class=detailorder>%s</td>
	              <td class=detailorder><input type=\"text\" size=\"42\" name=\"value\" value=\"%s\"></td>
	              <td class=detailorder>%s</td>
	              <td><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Update\" style=\";\"></td>
	              </tr></form>\n", $settingsarray["id"], $settingsarray["name"], $settingsarray["value"], $settingsarray["desc"]);
	          }
	      }
	      while ($settingsarray = mysql_fetch_array($settings));
	  }
	  else
	  {
	      echo "<tr><td colspan=5><b>ERROR ERROR ERROR</b></td></tr>\n";
	  }
      echo "</table><P>&nbsp;</P></table>";
      $num_rowsa = mysql_num_rows($servers);
      if ($num_rowsa > '0') {
      echo "<center><table border=\"1\" style=\"width:750;\" CELLPADDING=\"2\" CELLSPACING=\"2\" class=\"\" bordercolor=\"black\">\n";
	  echo "<tr><td class=titleorder colspan=5><b>Archive & Purge data</b></td></tr>\n";
	  echo "<tr><td colspan=5><a href=\"archive.php\">Archive data</a></td></tr></table></center>\n";
}
     echo "<center><img src=\"images/statusmon.gif\" alt=\"Free uptime and service monitoring script from www.sillydns.com\" border=\"0\"><BR><a href=\"admin.php?type=changepass\">Change Password</a> | <a href=\"admin.php?type=logout\">Logout</a><BR>". $tag . "</center>";
 }

 ?>


</body>
</html>

<?php

function showHeader()
{
    ?>
      <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

<html>
<head><title><?php echo $title; ?> Admin Panel</title>
<link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
<link rel="icon" href="favicon.ico" type="image/x-icon">
<LINK rel="stylesheet" type="text/css" href="style.css">
<script>
<!--
function sf(){document.f.username.focus();}
// -->
</script>
</head>

<body onLoad=sf()>
<p>&nbsp;</p>
<?php
}

function showLoginForm($feedback)
{
    ?>
   <form action="admin.php" method="post" name="f" id="">
   <table width="300" border="0" align="center" cellpadding="4" cellspacing="0" align="center">
   <?php if ($feedback) {
	echo '
	<tr>
		<td colspan="2" align="center" class=font style="color: red;">'. $feedback. '</td>
	</tr>';
	}
	?>
    <tr>
		<td class="titleorder" colspan="2">
		StatusMon login
		</td>
	</tr>
    <tr>
      <td class="formsubject" width="35%">Username:</td>
      <td class="formsubjectfield" width="65%"><input name="username" type="text" id="username" SIZE="10" MAXLENGTH="25"></td>
    </tr>
    <tr>
      <td class="formsubject">Password:</td>
      <td class="formsubjectfield"><input name="password" type="password" id="password" SIZE="10" MAXLENGTH="25"></td>
    </tr>
    <tr>
      <td colspan="2"><input class="formfield" type="submit" name="iflogmein" value="Submit" SIZE="10" MAXLENGTH="25"></td>
    </tr>
  </table>
</form>
<form action="admin.php" method="post" name ="" id="">
<table width="300" border="0" align="center" cellpadding="4" cellspacing="0" align="center">
<tr><td colspan="2">Forgot Password?</td></tr>
<tr>
    <td class="formsubject" width="35%">Email Address:</td>
    <td class="formsubjectfield" width="65%"><input name="email" type="text" id="email" SIZE="10" MAXLENGTH="50"></td>
<tr>
  <td colspan="2"><input class="formfield" type="submit" name="forgotpass" value="Retrieve" SIZE="10" MAXLENGTH="25"></td>
</tr>
</table></form>

<center><img src="images/statusmon.gif" alt="Free uptime and service monitoring script from www.sillydns.com" border="0"><BR><span style="color: red;">Statusmon  <?php echo $version; ?></span> Free uptime and service monitoring script from <a target="_blank" href="http://www.sillydns.com/statusmon.php">sillydns.com</a></center>

<?php
}

function validatelogin($user, $password, $connection)
{
    $sql = sprintf("SELECT `id` FROM `users` WHERE `username`='%s' AND `password`=MD5('%s')",mysql_real_escape_string($user,$connection),mysql_real_escape_string($password,$connection));
    $result = mysql_query($sql,$connection) or die("ERROR: ".$sql);
    list($id) = mysql_fetch_row($result);
    $_SESSION["userid"] = $id;
    if (mysql_num_rows($result) == 1) return 1;
    else return 0;
}

function logout()
{
    session_destroy();
    showLoginForm("You have been logged off successfully.");
}

function forgotpass($email,$connection)
{
    $sql = sprintf("SELECT `id` FROM `users` WHERE `email`='%s'",mysql_real_escape_string($email,$connection));
    $result = mysql_query($sql,$connection);
    if(!$result) return false;
    list($id) = mysql_fetch_row($result);

    $new_password = "";
    $i = 8;
    while($i--)
        $new_password .= chr(mt_rand(33,126));
    $sql = "UPDATE `users` SET `password`=MD5('$new_password') WHERE `id`='$id'";
    $result = mysql_query($sql,$connection);
    mail($email,"Statusmon Forgot Password","Your new password is: ".$new_password,"FROM: noreply@".$_SERVER["HTTP_HOST"]);
    return true;
}

function changepassform($warning = "")
{
    echo "<table align=\"center\" border=\"0\" style=\"width:650;\" CELLPADDING=\"0\" CELLSPACING=\"0\" class=\"\" bordercolor=\"black\"><tr><td>\n";
    echo "<table border=\"1\" style=\"width:650;\" CELLPADDING=\"2\" CELLSPACING=\"2\" class=\"\" bordercolor=\"black\">\n";
	echo "<tr><td colspan=4><b>Change Password</b></td></tr>\n";
	if ($warning != "") echo "<tr><td colspan=5 style=\"color: red; font-weight: bold;\">" .$warning . "</td></tr>\n";
    echo "<form method=\"post\" name=\"changepass\" action=\"admin.php\" id=\"changepass\"";
	echo "<tr><td class=titleorder>Old Pass</td><td class=titleorder>New Pass</td><td class=titleorder>New Pass</td><td class=titleorder>Update</td></tr>\n";
	echo "<input type=\"hidden\" name=\"type\" value=\"changepass\">";
	echo "<input type=\"hidden\" name=\"userid\" value=\"".$_SESSION['userid']."\">";
	echo "<tr><td class=detailorder><input type=\"text\" name=\"oldpass\"></td>";
	echo "<td class=detailorder><input type=\"text\" name=\"newpass1\"></td>";
	echo "<td class=detailorder><input type=\"text\" name=\"newpass2\"></td>";
	echo "<td><center><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Update\" style=\";\"></center></td></tr>";
	echo "</form></table></table>";
	echo "<br><center><a href=\"admin.php\">Back</a></center>";
}

function changepass($connection)
{
    if($_POST["oldpass"] == "" || $_POST["newpass1"] == "" || $_POST["newpass2"] == "") changepassform("Passwords cannot be blank.");
    elseif ($_POST["newpass1"] != $_POST["newpass2"]) changepassform("New passwords must match.");
    else
    {
        $sql = sprintf("UPDATE `users` SET `password`=MD5('%s') WHERE `id`='%s'",mysql_real_escape_string($_POST['newpass1'],$connection),
        mysql_real_escape_string($_POST['userid'],$connection));
        mysql_query($sql,$connection) or die("ERROR: ".$sql);
        changepassform("Password updated successfully.");
    }
}
function servermonitor($id,$connection)
{
    $settings = mysql_query("SELECT `default` FROM `servers` WHERE `id`='".$id."'") or die ("Couldn't connect to settings.");
    list($uptimeid) = mysql_fetch_row($settings);
    $service = new Service($connection);
    $servicelist = $service->getAll();
    $server = new Server($connection);
    $serverinfo = $server->getInfo($id);
    echo "<table align=\"center\" border=\"0\" style=\"width:650;\" CELLPADDING=\"0\" CELLSPACING=\"0\" class=\"\" bordercolor=\"black\"><tr><td>\n";
    echo "<table border=\"1\" style=\"width:650;\" CELLPADDING=\"2\" CELLSPACING=\"2\" class=\"\" bordercolor=\"black\">\n";
	printf("<tr><td colspan=3><b>Server: %s (%s)</b></td></tr>\n",$serverinfo["name"],$serverinfo["ip"]);
    echo "<tr><td colspan=3><b>Services to monitors:</b></td></tr>\n";
    echo "<form method=\"post\" name=\"monitor\" action=\"admin.php\" id=\"monitor\"";
	echo "<tr><td class=titleorder>Service</td><td class=titleorder>Port</td><td class=titleorder>Monitor this service?</td></tr>\n";
	echo "<input type=\"hidden\" name=\"type\" value=\"servermonitor\">";
	echo "<input type=\"hidden\" name=\"serverid\" value=\"".$id."\">";
    if (count($servicelist) > 0)
    {
        foreach($servicelist as $key=>$value)
        {
            $monitor = $server->monitorServer($id,$key);
            if ($monitor)
		    {
		        $yes = "checked=\"true\"";
		        $no = "";
		    }
		    else
		    {
		        $yes = "";
		        $no = "checked=\"true\"";
		    }
            printf("<tr><td class=detailorder>%s</td>
		    <td class=detailorder>%s</td>
		    <td class=detailorder><input type=\"radio\" name=\"%s\" value=\"1\" %s>&nbsp;YES&nbsp;&nbsp;&nbsp;
			<input type=\"radio\" name=\"%s\" value=\"0\" %s>&nbsp;NO</td>
		    </tr>", $value["name"], $value["port"], $key, $yes, $key, $no);
        }
        echo "<td colspan=3><center><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Update\" style=\";\"></center></td>";
        echo "</form></table>";

        echo "<P>&nbsp;</P>";
        echo "<table border=\"1\" style=\"width:650;\" CELLPADDING=\"2\" CELLSPACING=\"2\" class=\"\" bordercolor=\"black\">\n";
        echo "<tr><td colspan=3><b>Service used to calculate uptime stats:</b></td></tr>\n";
	    echo "<tr><td class=titleorder>Service</td><td class=titleorder colspan=2>Update</td></tr>\n";
        echo "<form method=\"post\" name=\"uptime\" action=\"admin.php\" id=\"uptime\"";
       	echo "<input type=\"hidden\" name=\"type\" value=\"servermonitor\">";
	    echo "<input type=\"hidden\" name=\"serverid\" value=\"".$id."\">";
	    echo "<td class=detailorder><select name=\"monitor\">";
	    reset($servicelist);
	    foreach($servicelist as $servicekey=>$serviceval)
	    {
	        if ($uptimeid == $servicekey) echo "<option value=\"$servicekey\" selected>".$serviceval["name"];
	        else echo "<option value=\"$servicekey\">".$serviceval["name"];
	    }
	    echo "</select></td>";
        echo "<td><center><input class=\"formfield\" name=\"action\" type=\"Submit\" value=\"Update\" style=\";\"></center></td>";
      }
      else
      {
          echo "<tr><td colspan=\"5\"><b>No services to monitor</b></td></tr>\n";
	  }
	  printf("</form></table></table>\n");
	  echo "<br><center><a href=\"admin.php\">Back</a></center>";
	  echo "</body></html>";
}
?>